<?php
// Merged enhanced version: WhatsApp + CSV + Auto-refresh + Sound Alert + Charts + Device status

date_default_timezone_set('Asia/Kolkata');
$conn = new mysqli("localhost", "pavancom_bm", "Acer@123123", "pavancom_bm");
if ($conn->connect_error) die("Connection failed: " . $conn->connect_error);

function send_whatsapp_summary($summaryText) {
    $apiKey = "jGvypPi2hsXCUPIBN42zqyg5KSik7V";
    $sender = "919999999988";
    $receiver = "919908302604";
    $encodedMessage = urlencode($summaryText);

    $apiUrl = "https://whatsapplogin.pavancomputers.com/send-message?api_key=$apiKey&sender=$sender&number=$receiver&message=$encodedMessage";

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $apiUrl);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    $response = curl_exec($ch);
    curl_close($ch);
}

if (isset($_GET['send_summary'])) {
    $result = $conn->query("SELECT device_id, COUNT(*) as count FROM device_command_logs WHERE DATE(received_time) = CURDATE() GROUP BY device_id");
    $text = "97 Today's Device Summary (" . date('d-m-Y') . ")\n";
    while ($row = $result->fetch_assoc()) {
        $text .= "\n97 {$row['device_id']}: {$row['count']} commands";
    }
    send_whatsapp_summary($text);
    echo "<script>alert('Summary sent to WhatsApp');window.location='view_command_logs.php';</script>";
    exit;
}

$deviceFilter = $_GET['device_id'] ?? '';
$dateFilter = $_GET['date'] ?? '';
$searchCmd = $_GET['cmd_id'] ?? '';
$where = "WHERE 1=1";
if ($deviceFilter) $where .= " AND device_id = '" . $conn->real_escape_string($deviceFilter) . "'";
if ($dateFilter) $where .= " AND DATE(received_time) = '" . $conn->real_escape_string($dateFilter) . "'";
if ($searchCmd) $where .= " AND cmd_id LIKE '%" . $conn->real_escape_string($searchCmd) . "%'";

if (isset($_GET['export']) && $_GET['export'] === 'csv') {
    header('Content-Type: text/csv');
    header('Content-Disposition: attachment;filename=device_command_logs.csv');
    $output = fopen('php://output', 'w');
    fputcsv($output, ['ID', 'Device ID', 'Request Code', 'Command ID', 'Block No', 'Block Len', 'Content Length', 'Received Time']);
    $result = $conn->query("SELECT * FROM device_command_logs $where ORDER BY received_time DESC");
    while ($row = $result->fetch_assoc()) fputcsv($output, $row);
    fclose($output); exit;
}

$logs = $conn->query("SELECT * FROM device_command_logs $where ORDER BY received_time DESC LIMIT 200");
$summary = $conn->query("SELECT device_id, COUNT(*) AS total FROM device_command_logs GROUP BY device_id");
$daily = $conn->query("SELECT DATE(received_time) AS day, COUNT(*) AS total FROM device_command_logs GROUP BY day ORDER BY day DESC LIMIT 7");
$devices = $conn->query("SELECT DISTINCT device_id FROM device_command_logs");
$statuses = $conn->query("SELECT device_id, last_seen FROM device_status");
$device_status = [];
while ($row = $statuses->fetch_assoc()) {
    $device_status[$row['device_id']] = $row['last_seen'];
}
?>
<!DOCTYPE html>
<html>
<head>
    <title>Device Command Logs Dashboard</title>
    <style>
        body { font-family: Arial; margin: 20px; background: #f4f4f4; }
        h2 { color: #333; }
        .btn { padding: 8px 15px; background: #333; color: #fff; text-decoration: none; margin-bottom: 15px; display: inline-block; }
        table { width: 100%; border-collapse: collapse; background: #fff; box-shadow: 0 0 5px #ccc; }
        th, td { padding: 10px; border: 1px solid #ddd; text-align: left; }
        th { background: #222; color: #fff; }
        tr:nth-child(even) { background: #f9f9f9; }
        .charts { display: flex; gap: 40px; margin-bottom: 40px; }
        .filters { margin-bottom: 20px; }
        .online { color: green; font-weight: bold; }
        .offline { color: red; font-weight: bold; }
        .toggle-refresh { margin-left: 15px; cursor: pointer; font-size: 14px; color: blue; text-decoration: underline; }
    </style>
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
</head>
<body>

<h2>96 Device Command Logs Dashboard <span id="refreshToggle" class="toggle-refresh" onclick="toggleAutoRefresh()"></span></h2>
<audio id="notifySound" src="https://notificationsounds.com/storage/sounds/file-sounds-1157-pristine.mp3" preload="auto"></audio>
<a href="?<?= http_build_query(array_merge($_GET, ['export' => 'csv'])) ?>" class="btn">98 Export CSV</a>
<a href="?send_summary=1" class="btn" style="background:#007a2c">95 Send WhatsApp Summary</a>

<h3>97 Total Commands Per Device</h3>
<table>
    <tr><th>Device ID</th><th>Total Commands</th></tr>
    <?php $summary->data_seek(0); while ($r = $summary->fetch_assoc()): ?>
        <tr><td><?= $r['device_id'] ?></td><td><?= $r['total'] ?></td></tr>
    <?php endwhile; ?>
</table>

<form method="get" class="filters">
    <label>Device:
        <select name="device_id">
            <option value="">All</option>
            <?php $devices->data_seek(0); while($d = $devices->fetch_assoc()): ?>
                <option value="<?= $d['device_id'] ?>" <?= ($d['device_id'] == $deviceFilter) ? 'selected' : '' ?>><?= $d['device_id'] ?></option>
            <?php endwhile; ?>
        </select>
    </label>
    <label>Date: <input type="date" name="date" value="<?= htmlspecialchars($dateFilter) ?>"></label>
    <label>Command ID: <input type="text" name="cmd_id" value="<?= htmlspecialchars($searchCmd) ?>"></label>
    <button type="submit" class="btn">Filter</button>
</form>

<div class="charts">
    <canvas id="perDeviceChart" width="400" height="200"></canvas>
    <canvas id="dailyChart" width="400" height="200"></canvas>
</div>

<h3>92 Device Status (Live)</h3>
<table>
    <tr><th>Device ID</th><th>Last Seen</th><th>Status</th></tr>
    <?php foreach ($device_status as $id => $seen):
        $last = strtotime($seen);
        $diff = time() - $last;
        $status = ($diff <= 180) ? '<span class="online">Online</span>' : '<span class="offline">Offline</span>';
    ?>
        <tr><td><?= $id ?></td><td><?= $seen ?></td><td><?= $status ?></td></tr>
    <?php endforeach; ?>
</table>

<h3>Recent Command Logs</h3>
<table>
    <tr>
        <th>ID</th>
        <th>Device ID</th>
        <th>Request Code</th>
        <th>Command ID</th>
        <th>Block No</th>
        <th>Block Len</th>
        <th>Content Length</th>
        <th>Received Time</th>
    </tr>
    <?php if ($logs->num_rows > 0): while ($row = $logs->fetch_assoc()): ?>
        <tr>
            <td><?= $row['id'] ?></td>
            <td><?= $row['device_id'] ?></td>
            <td><?= $row['request_code'] ?></td>
            <td><?= $row['cmd_id'] ?></td>
            <td><?= $row['block_no'] ?></td>
            <td><?= $row['block_len'] ?></td>
            <td><?= $row['content_length'] ?></td>
            <td><?= $row['received_time'] ?></td>
        </tr>
    <?php endwhile; else: ?>
        <tr><td colspan='8'>No logs found.</td></tr>
    <?php endif; ?>
</table>

<script>
const deviceLabels = [<?php $summary->data_seek(0); while ($r = $summary->fetch_assoc()) echo "'{$r['device_id']}',"; ?>];
const deviceCounts = [<?php $summary->data_seek(0); while ($r = $summary->fetch_assoc()) echo "{$r['total']},"; ?>];
const dailyLabels = [<?php $daily->data_seek(0); while ($r = $daily->fetch_assoc()) echo "'{$r['day']}',"; ?>];
const dailyCounts = [<?php $daily->data_seek(0); while ($r = $daily->fetch_assoc()) echo "{$r['total']},"; ?>];

new Chart(document.getElementById('perDeviceChart'), {
    type: 'bar',
    data: {
        labels: deviceLabels,
        datasets: [{ label: 'Commands per Device', data: deviceCounts, backgroundColor: '#007acc' }]
    }
});

new Chart(document.getElementById('dailyChart'), {
    type: 'line',
    data: {
        labels: dailyLabels,
        datasets: [{ label: 'Commands per Day', data: dailyCounts, backgroundColor: '#f39c12', borderColor: '#e67e22', fill: true }]
    }
});

let autoRefreshEnabled = true;
const refreshKey = 'autoRefresh';
if (localStorage.getItem(refreshKey) === 'false') autoRefreshEnabled = false;
function toggleAutoRefresh() {
    autoRefreshEnabled = !autoRefreshEnabled;
    localStorage.setItem(refreshKey, autoRefreshEnabled);
    document.getElementById('refreshToggle').innerText = autoRefreshEnabled ? '94 Auto-refresh is ON (click to stop)' : '7215 Auto-refresh is OFF (click to start)';
}

document.addEventListener("DOMContentLoaded", () => {
    const latestRow = document.querySelector("table tr:nth-child(2) td");
    if (!latestRow) return;
    const currentId = latestRow.innerText.trim();
    const lastSeenId = localStorage.getItem("lastCommandId");
    if (lastSeenId && currentId !== lastSeenId) document.getElementById("notifySound").play();
    localStorage.setItem("lastCommandId", currentId);
    document.getElementById('refreshToggle').innerText = autoRefreshEnabled ? '94 Auto-refresh is ON (click to stop)' : '7215 Auto-refresh is OFF (click to start)';
    if (autoRefreshEnabled) setTimeout(() => location.reload(), 15000);
});
</script>
</body>
</html>
